--[[
    About Premake5, see https://github.com/premake/premake-core/wiki
    Author: Moț
]]

function get_git_revision()
    local handle = io.popen("git describe --tags --always")
    local result = handle:read("*a")
    handle:close()
    return string.gsub(result, "%s+", "")
end

workspace "Sinners2"
    platforms {
       -- "x64",
        "x32"
    }

    warnings "Default"

    configurations {
        "Debug",
        "Release",
        "Distribute"
    }

    staticruntime "on"
    language "C++"
    cppdialect "C++17"
    largeaddressaware "on"
    location "build"

    ROOT = _WORKING_DIR

    filter "platforms:*32"
        architecture "x86"
    filter "platforms:*64"
        architecture "x64"

    filter {}

    includedirs {
        "extern/include",
        "extern/include/d3d8",
        "extern/include/granny2",
        "extern/include/python2",
        "extern/include/cef",
    }

    libdirs {
        "extern/lib",
        "extern/lib/%{cfg.system}/%{cfg.platform}",
        "extern/lib/%{cfg.system}/%{cfg.platform}/%{cfg.runtime}"
    }

    local os_ver = os.getversion()
    local hostname = string.format("__HOSTNAME__=\" %d.%d.%d (%s)\"", os_ver.majorversion, os_ver.minorversion, os_ver.revision, os_ver.description)
    local target_os = string.format("__TARGET_OS__=\"%s\"", os.target())
    local working_dir = string.format("__WORKING_DIR__=\"%s\"", _WORKING_DIR)
    local premake_ver = string.format("__PREMAKE_VERSION__=\"%s\"", _PREMAKE_VERSION)
    local git_revision = string.format("__GIT_REVISION_HASH__=\"%s\"", get_git_revision())
    defines {
        "__BUILD_TYPE__=\"%{cfg.buildcfg}\"",
        "__TOOLSET__=\"%{cfg.toolset}\"",
        "__ARCHITECTURE__=\"%{cfg.architecture}\"",
        hostname,
        target_os,
        working_dir,
        premake_ver,
        git_revision,
        "FMT_HEADER_ONLY",
    }

    filter "configurations:Debug"
       defines {
           "_DEBUG"
        }
       runtime "Debug"
       symbols "full"

    filter "configurations:Release"
        defines {
            "NDEBUG"
        }
       runtime "Release"
       optimize "On"
       symbols "On"

    filter "configurations:Distribute"
       defines {
           "NDEBUG",
           "DISTRIBUTE",
           "__USE_CYTHON__"
       }
      runtime "Release"
      optimize "Full"
      symbols "Off"

    filter "action:vs*"
        systemversion "latest"
        atl ("Static")

        defines {
            "_CRT_SECURE_NO_WARNINGS",
            "_HAS_STD_BYTE=0",
        }

        disablewarnings {
            "4242",
            "4307",
            "4996",
            "4244",
            "4267",
        }

        characterset "MBCS"

        flags {
            "MultiProcessorCompile",
            "NoBufferSecurityCheck",
            "NoRuntimeChecks",
            "RelativeLinks",
        }

    filter { "platforms:*32", "action:vs*"}
        defines { "_USE_32BIT_TIME_T" }
    filter {}

    if os.istarget("windows") then
        group "client"
            project "CWebBrowser"
                kind "StaticLib"
                language "C"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.c"
                }

            project "EffectLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "EterBase"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "EterFSLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.hpp",
                    "source/%{prj.group}/%{prj.name}/**.cpp",
                    "source/%{prj.group}/%{prj.name}/**.asm",
                    "source/%{prj.group}/%{prj.name}/**.inc"
                }
            project "EterGrnLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "EterImageLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "EterLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "EterLocale"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "EterPythonLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "GameLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "MilesLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "Stdafx.h"
                pchsource "source/%{prj.group}/%{prj.name}/Stdafx.cpp"

            project "PRTerrainLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "rootlib"
                kind "StaticLib"
                removeplatforms { "x64" }
                language "C"
                targetdir (ROOT .. "/extern/lib/%{cfg.system}/%{cfg.platform}/%{cfg.runtime}")
                
                files {
                    "client/%{prj.name}/**.c",
                }
                
                defines {
                    "CYTHON_NO_PYINIT_EXPORT"
                }

                disablewarnings {
                    "4146" -- C4146: unary minus operator applied to unsigned type, result still unsigned
                }

            project "ScriptLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "SpeedTreeLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "SphereLib"
                kind "StaticLib"
                removeplatforms { "x64" }
                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }
                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

            project "UserInterface"
                kind "WindowedApp"
                targetdir (ROOT .. "/client")
                targetname "Sinners2"
                targetsuffix "_%{cfg.architecture}_%{cfg.buildcfg}"
                removeplatforms { "x64" }

                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp",
                    "source/%{prj.group}/%{prj.name}/**.rc",
                    "source/%{prj.group}/%{prj.name}/**.ico"
                }

                pchheader "StdAfx.h"
                pchsource "source/%{prj.group}/%{prj.name}/StdAfx.cpp"

                ignoredefaultlibraries { "libci" }

                links {
                    "CWebBrowser",
                    "EffectLib",
                    "EterBase",
                    "EterFSLib",
                    "EterGrnLib",
                    "EterImageLib",
                    "EterLib",
                    "EterLocale",
                    "EterPythonLib",
                    "GameLib",
                    "MilesLib",
                    "PRTerrainLib",
                    "ScriptLib",
                    "SpeedTreeLib",
                    "SphereLib"
                }

                linkoptions {
                    "/ignore:4098",
                    "/ignore:4099",
                }

                configuration {
                    "Release or Distribute",
                    "vs*"
                }
                    linkoptions {
                        "/SAFESEH:NO"
                    }

                    flags {
                        "LinkTimeOptimization",
                        "NoIncrementalLink",
                        "NoImplicitLink",
                    }

                configuration {
                    "Distribute",
                    "vs*"
                }
                    postbuildcommands {
                        "{COPYFILE} %{cfg.buildtarget.abspath} %{wks.location}..\\..\\sinners2_client\\%{cfg.targetname}%{cfg.buildtarget.extension}"
                    }
                    linkoptions {
                        "/MANIFESTUAC:\"level='requireAdministrator' uiAccess='false'\""
                    }
    end
    group "server"
        project "libthecore"
            kind "StaticLib"

            files {
                "source/%{prj.group}/%{prj.name}/**.h",
                "source/%{prj.group}/%{prj.name}/**.cpp"
            }
            filter "action:not vs*"
                disablewarnings {
                    "invalid-source-encoding",
                }
                pchheader "source/%{prj.group}/%{prj.name}/stdafx.h"
            filter "action:vs*"
                pchheader "stdafx.h"
                pchsource "source/%{prj.group}/%{prj.name}/stdafx.cpp"

        project "libsql"
            kind "StaticLib"

            files {
                "source/%{prj.group}/%{prj.name}/**.h",
                "source/%{prj.group}/%{prj.name}/**.cpp"
            }

            filter "action:not vs*"
                pchheader "source/%{prj.group}/%{prj.name}/stdafx.h"
            filter "action:vs*"
                pchheader "stdafx.h"
                pchsource "source/%{prj.group}/%{prj.name}/stdafx.cpp"

        project "libpoly"
            kind "StaticLib"

            files {
                "source/%{prj.group}/%{prj.name}/**.h",
                "source/%{prj.group}/%{prj.name}/**.cpp"
            }

            filter "action:not vs*"
                pchheader "source/%{prj.group}/%{prj.name}/stdafx.h"
            filter "action:vs*"
                pchheader "stdafx.h"
                pchsource "source/%{prj.group}/%{prj.name}/stdafx.cpp"

        project "liblua"
            kind "StaticLib"
            language "C"
            files {
                "source/%{prj.group}/%{prj.name}/**.h",
                "source/%{prj.group}/%{prj.name}/**.c",
            }

        project "libgame"
            kind "StaticLib"

            files {
                "source/%{prj.group}/%{prj.name}/**.h",
                "source/%{prj.group}/%{prj.name}/**.cpp"
            }

            filter "action:not vs*"
                pchheader "source/%{prj.group}/%{prj.name}/stdafx.h"
            filter "action:vs*"
                pchheader "stdafx.h"
                pchsource "source/%{prj.group}/%{prj.name}/stdafx.cpp"

        project "quest"
            kind "ConsoleApp"
            targetdir (ROOT .. "/bin")
            targetname "qc"
            targetsuffix "_%{cfg.architecture}_%{cfg.buildcfg}"

            files {
                "source/%{prj.group}/%{prj.name}/**.h",
                "source/%{prj.group}/%{prj.name}/**.cc"
            }

            links {
                "liblua",
                --"common"
            }

        project "db"
            kind "ConsoleApp"
            targetdir (ROOT .. "/bin")
            targetsuffix "_%{cfg.architecture}_%{cfg.buildcfg}"

            files {
                "source/%{prj.group}/%{prj.name}/**.h",
                "source/%{prj.group}/%{prj.name}/**.cpp"
            }

            links {
                "libgame",
                "libpoly",
                "libsql",
                "libthecore",
            }

            filter "action:not vs*"
                pchheader "source/%{prj.group}/%{prj.name}/stdafx.h"
            filter "action:vs*"
                pchheader "stdafx.h"
                pchsource "source/%{prj.group}/%{prj.name}/stdafx.cpp"

            filter "system:bsd"
                links { "pthread" }

            filter "system:windows"
                links {
                    "ws2_32",
                    "shlwapi",
                    "mariadbclient"
                }
                postbuildcommands {
                    "{COPYFILE} %{cfg.buildtarget.abspath} %{cfg.buildtarget.directory}\\%{prj.name}%{cfg.buildtarget.extension}"
                }
            filter {}

            links {
                "mariadbclient"
            }

        project "game"
            kind "ConsoleApp"
            targetdir (ROOT .. "/bin")
            targetsuffix "_%{cfg.architecture}_%{cfg.buildcfg}"

            files {
                "source/%{prj.group}/%{prj.name}/**.h",
                "source/%{prj.group}/%{prj.name}/**.hpp",
                "source/%{prj.group}/%{prj.name}/**.cpp"
            }

            links {
                --"common",
                "libgame",
                "libpoly",
                "libsql",
                "libthecore",
                "liblua",
            }

            filter "action:not vs*"
                pchheader "source/%{prj.group}/%{prj.name}/stdafx.h"
            filter "action:vs*"
                pchheader "stdafx.h"
                pchsource "source/%{prj.group}/%{prj.name}/stdafx.cpp"

            filter "system:bsd"
                links {
                    "pthread",
                    "IL",
                    "jpeg",
                    "lzma",
                    "md",
                    "z",
                    "sodium",
                    --"bcrypt",
                    --"cryptopp"
                }

                disablewarnings {
                    "invalid-source-encoding",
                }

            filter "system:windows"
                links {
                    "ws2_32",
                    "shlwapi",
                    "DevIL",
                    "cryptopp-static",
                    "libsodium"
                }
                linkoptions {
                    "/ignore:4098",
                    "/ignore:4099"
                }
                postbuildcommands {
                    "{COPYFILE} %{cfg.buildtarget.abspath} %{cfg.buildtarget.directory}\\%{prj.name}%{cfg.buildtarget.extension}"
                }

            filter {}
            links {
                "mariadbclient",
                "lzo2",
            }

    if os.istarget("windows") then
        group "common"
            project "common"
            kind "SharedItems"

            files {
                "source/server/common/**.h",
            }

            --pchheader "stdafx.h"
            --pchsource "source/%{prj.group}/%{prj.name}/stdafx.cpp"
    end

    group "tools"
        if os.istarget("windows") then
            project "FSArchiver"
                kind "ConsoleApp"
                targetdir (ROOT .. "/bin")
                targetsuffix "_%{cfg.architecture}_%{cfg.buildcfg}"
                removeplatforms { "x64" }

                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }

                defines {
                    "TBB_SUPPRESS_DEPRECATED_MESSAGES"
                }

                links {
                    "EterFSLib",
                    "lzo2",
                    "lz4",
                    "xxhash",
                    "zlib",
                    "cryptopp-static"
                }

                linkoptions {
                    "/ignore:4098",
                    "/ignore:4099"
                }
            project "PropertyGenerator"
                kind "ConsoleApp"
                targetdir (ROOT .. "/bin")
                targetsuffix "_%{cfg.architecture}_%{cfg.buildcfg}"
                removeplatforms { "x64" }

                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }

                links {
                    "EterFSLib",
                    "lzo2",
                    "lz4",
                    "xxhash",
                    "zlib",
                    "cryptopp-static"
                }

                linkoptions {
                    "/ignore:4098",
                    "/ignore:4099"
                }
				--[[
            project "DumpProto"
                kind "ConsoleApp"
                targetdir (ROOT .. "/bin")
                targetsuffix "_%{cfg.architecture}_%{cfg.buildcfg}"
                removeplatforms { "x64" }

                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }

                links {
                    "EterBase",
                    "lzo2",
                }

                linkoptions {
                    "/ignore:4098",
                    "/ignore:4099"
                }

                -- pchheader "pch.h"
                -- pchsource "source/%{prj.group}/%{prj.name}/pch.cpp"
            --]]
            
            project "MSAMaker"
                kind "ConsoleApp"
                targetdir (ROOT .. "/bin")
                targetsuffix "_%{cfg.architecture}_%{cfg.buildcfg}"
                removeplatforms { "x64" }

                files {
                    "source/%{prj.group}/%{prj.name}/**.h",
                    "source/%{prj.group}/%{prj.name}/**.cpp"
                }

                linkoptions {
                    "/ignore:4098",
                    "/ignore:4099"
                }

                pchheader "stdafx.h"
                pchsource "source/%{prj.group}/%{prj.name}/stdafx.cpp"
        end

    group "utilities"
        if os.istarget("windows") then
            project "cythonizer"
            kind "Utility"
            removeplatforms { "x64" }

            files {
                "%{wks.location}\\..\\client\\rootlibcythonizer.py",
                "%{wks.location}\\..\\client\\root\\**.py",
                "%{wks.location}\\..\\client\\uiscript\\**.py",
            }

            prebuildmessage "Cythonizing python files!"
            prebuildcommands {
                "cd %{wks.location}\\..\\client & C:\\Python27\\python.exe rootlibcythonizer.py -f",
                "cd %{wks.location}\\..\\ & tools\\premake5 %{_ACTION} --file=\"premake5.lua\""
            }
            postbuildcommands {
                "msbuild /m /maxcpucount /t:Build /p:Configuration=%{cfg.buildcfg} %{wks.location}/rootlib.vcxproj"
            }
        end